// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SQSHL_8H_2OPIMM_TRACE_AARCH64_H_
#define VIXL_SIM_SQSHL_8H_2OPIMM_TRACE_AARCH64_H_

const uint16_t kExpected_NEON_sqshl_8H_2OPIMM[] = {
  0xff81, 0xff82, 0xff83, 0xfff0, 0xfffd, 0xfffe, 0xffff, 0x0000,
  0xff02, 0xff04, 0xff06, 0xffe0, 0xfffa, 0xfffc, 0xfffe, 0x0000,
  0xfe04, 0xfe08, 0xfe0c, 0xffc0, 0xfff4, 0xfff8, 0xfffc, 0x0000,
  0xfc08, 0xfc10, 0xfc18, 0xff80, 0xffe8, 0xfff0, 0xfff8, 0x0000,
  0xf810, 0xf820, 0xf830, 0xff00, 0xffd0, 0xffe0, 0xfff0, 0x0000,
  0xf020, 0xf040, 0xf060, 0xfe00, 0xffa0, 0xffc0, 0xffe0, 0x0000,
  0xe040, 0xe080, 0xe0c0, 0xfc00, 0xff40, 0xff80, 0xffc0, 0x0000,
  0xc080, 0xc100, 0xc180, 0xf800, 0xfe80, 0xff00, 0xff80, 0x0000,
  0x8100, 0x8200, 0x8300, 0xf000, 0xfd00, 0xfe00, 0xff00, 0x0000,
  0x8000, 0x8000, 0x8000, 0xe000, 0xfa00, 0xfc00, 0xfe00, 0x0000,
  0x8000, 0x8000, 0x8000, 0xc000, 0xf400, 0xf800, 0xfc00, 0x0000,
  0x8000, 0x8000, 0x8000, 0x8000, 0xe800, 0xf000, 0xf800, 0x0000,
  0x8000, 0x8000, 0x8000, 0x8000, 0xd000, 0xe000, 0xf000, 0x0000,
  0x8000, 0x8000, 0x8000, 0x8000, 0xa000, 0xc000, 0xe000, 0x0000,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0xc000, 0x0000,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x0000,
  0xff82, 0xff83, 0xfff0, 0xfffd, 0xfffe, 0xffff, 0x0000, 0x0001,
  0xff04, 0xff06, 0xffe0, 0xfffa, 0xfffc, 0xfffe, 0x0000, 0x0002,
  0xfe08, 0xfe0c, 0xffc0, 0xfff4, 0xfff8, 0xfffc, 0x0000, 0x0004,
  0xfc10, 0xfc18, 0xff80, 0xffe8, 0xfff0, 0xfff8, 0x0000, 0x0008,
  0xf820, 0xf830, 0xff00, 0xffd0, 0xffe0, 0xfff0, 0x0000, 0x0010,
  0xf040, 0xf060, 0xfe00, 0xffa0, 0xffc0, 0xffe0, 0x0000, 0x0020,
  0xe080, 0xe0c0, 0xfc00, 0xff40, 0xff80, 0xffc0, 0x0000, 0x0040,
  0xc100, 0xc180, 0xf800, 0xfe80, 0xff00, 0xff80, 0x0000, 0x0080,
  0x8200, 0x8300, 0xf000, 0xfd00, 0xfe00, 0xff00, 0x0000, 0x0100,
  0x8000, 0x8000, 0xe000, 0xfa00, 0xfc00, 0xfe00, 0x0000, 0x0200,
  0x8000, 0x8000, 0xc000, 0xf400, 0xf800, 0xfc00, 0x0000, 0x0400,
  0x8000, 0x8000, 0x8000, 0xe800, 0xf000, 0xf800, 0x0000, 0x0800,
  0x8000, 0x8000, 0x8000, 0xd000, 0xe000, 0xf000, 0x0000, 0x1000,
  0x8000, 0x8000, 0x8000, 0xa000, 0xc000, 0xe000, 0x0000, 0x2000,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0xc000, 0x0000, 0x4000,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x0000, 0x7fff,
  0xff83, 0xfff0, 0xfffd, 0xfffe, 0xffff, 0x0000, 0x0001, 0x0002,
  0xff06, 0xffe0, 0xfffa, 0xfffc, 0xfffe, 0x0000, 0x0002, 0x0004,
  0xfe0c, 0xffc0, 0xfff4, 0xfff8, 0xfffc, 0x0000, 0x0004, 0x0008,
  0xfc18, 0xff80, 0xffe8, 0xfff0, 0xfff8, 0x0000, 0x0008, 0x0010,
  0xf830, 0xff00, 0xffd0, 0xffe0, 0xfff0, 0x0000, 0x0010, 0x0020,
  0xf060, 0xfe00, 0xffa0, 0xffc0, 0xffe0, 0x0000, 0x0020, 0x0040,
  0xe0c0, 0xfc00, 0xff40, 0xff80, 0xffc0, 0x0000, 0x0040, 0x0080,
  0xc180, 0xf800, 0xfe80, 0xff00, 0xff80, 0x0000, 0x0080, 0x0100,
  0x8300, 0xf000, 0xfd00, 0xfe00, 0xff00, 0x0000, 0x0100, 0x0200,
  0x8000, 0xe000, 0xfa00, 0xfc00, 0xfe00, 0x0000, 0x0200, 0x0400,
  0x8000, 0xc000, 0xf400, 0xf800, 0xfc00, 0x0000, 0x0400, 0x0800,
  0x8000, 0x8000, 0xe800, 0xf000, 0xf800, 0x0000, 0x0800, 0x1000,
  0x8000, 0x8000, 0xd000, 0xe000, 0xf000, 0x0000, 0x1000, 0x2000,
  0x8000, 0x8000, 0xa000, 0xc000, 0xe000, 0x0000, 0x2000, 0x4000,
  0x8000, 0x8000, 0x8000, 0x8000, 0xc000, 0x0000, 0x4000, 0x7fff,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x0000, 0x7fff, 0x7fff,
  0xfff0, 0xfffd, 0xfffe, 0xffff, 0x0000, 0x0001, 0x0002, 0x0010,
  0xffe0, 0xfffa, 0xfffc, 0xfffe, 0x0000, 0x0002, 0x0004, 0x0020,
  0xffc0, 0xfff4, 0xfff8, 0xfffc, 0x0000, 0x0004, 0x0008, 0x0040,
  0xff80, 0xffe8, 0xfff0, 0xfff8, 0x0000, 0x0008, 0x0010, 0x0080,
  0xff00, 0xffd0, 0xffe0, 0xfff0, 0x0000, 0x0010, 0x0020, 0x0100,
  0xfe00, 0xffa0, 0xffc0, 0xffe0, 0x0000, 0x0020, 0x0040, 0x0200,
  0xfc00, 0xff40, 0xff80, 0xffc0, 0x0000, 0x0040, 0x0080, 0x0400,
  0xf800, 0xfe80, 0xff00, 0xff80, 0x0000, 0x0080, 0x0100, 0x0800,
  0xf000, 0xfd00, 0xfe00, 0xff00, 0x0000, 0x0100, 0x0200, 0x1000,
  0xe000, 0xfa00, 0xfc00, 0xfe00, 0x0000, 0x0200, 0x0400, 0x2000,
  0xc000, 0xf400, 0xf800, 0xfc00, 0x0000, 0x0400, 0x0800, 0x4000,
  0x8000, 0xe800, 0xf000, 0xf800, 0x0000, 0x0800, 0x1000, 0x7fff,
  0x8000, 0xd000, 0xe000, 0xf000, 0x0000, 0x1000, 0x2000, 0x7fff,
  0x8000, 0xa000, 0xc000, 0xe000, 0x0000, 0x2000, 0x4000, 0x7fff,
  0x8000, 0x8000, 0x8000, 0xc000, 0x0000, 0x4000, 0x7fff, 0x7fff,
  0x8000, 0x8000, 0x8000, 0x8000, 0x0000, 0x7fff, 0x7fff, 0x7fff,
  0xfffd, 0xfffe, 0xffff, 0x0000, 0x0001, 0x0002, 0x0010, 0x007d,
  0xfffa, 0xfffc, 0xfffe, 0x0000, 0x0002, 0x0004, 0x0020, 0x00fa,
  0xfff4, 0xfff8, 0xfffc, 0x0000, 0x0004, 0x0008, 0x0040, 0x01f4,
  0xffe8, 0xfff0, 0xfff8, 0x0000, 0x0008, 0x0010, 0x0080, 0x03e8,
  0xffd0, 0xffe0, 0xfff0, 0x0000, 0x0010, 0x0020, 0x0100, 0x07d0,
  0xffa0, 0xffc0, 0xffe0, 0x0000, 0x0020, 0x0040, 0x0200, 0x0fa0,
  0xff40, 0xff80, 0xffc0, 0x0000, 0x0040, 0x0080, 0x0400, 0x1f40,
  0xfe80, 0xff00, 0xff80, 0x0000, 0x0080, 0x0100, 0x0800, 0x3e80,
  0xfd00, 0xfe00, 0xff00, 0x0000, 0x0100, 0x0200, 0x1000, 0x7d00,
  0xfa00, 0xfc00, 0xfe00, 0x0000, 0x0200, 0x0400, 0x2000, 0x7fff,
  0xf400, 0xf800, 0xfc00, 0x0000, 0x0400, 0x0800, 0x4000, 0x7fff,
  0xe800, 0xf000, 0xf800, 0x0000, 0x0800, 0x1000, 0x7fff, 0x7fff,
  0xd000, 0xe000, 0xf000, 0x0000, 0x1000, 0x2000, 0x7fff, 0x7fff,
  0xa000, 0xc000, 0xe000, 0x0000, 0x2000, 0x4000, 0x7fff, 0x7fff,
  0x8000, 0x8000, 0xc000, 0x0000, 0x4000, 0x7fff, 0x7fff, 0x7fff,
  0x8000, 0x8000, 0x8000, 0x0000, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0xfffe, 0xffff, 0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e,
  0xfffc, 0xfffe, 0x0000, 0x0002, 0x0004, 0x0020, 0x00fa, 0x00fc,
  0xfff8, 0xfffc, 0x0000, 0x0004, 0x0008, 0x0040, 0x01f4, 0x01f8,
  0xfff0, 0xfff8, 0x0000, 0x0008, 0x0010, 0x0080, 0x03e8, 0x03f0,
  0xffe0, 0xfff0, 0x0000, 0x0010, 0x0020, 0x0100, 0x07d0, 0x07e0,
  0xffc0, 0xffe0, 0x0000, 0x0020, 0x0040, 0x0200, 0x0fa0, 0x0fc0,
  0xff80, 0xffc0, 0x0000, 0x0040, 0x0080, 0x0400, 0x1f40, 0x1f80,
  0xff00, 0xff80, 0x0000, 0x0080, 0x0100, 0x0800, 0x3e80, 0x3f00,
  0xfe00, 0xff00, 0x0000, 0x0100, 0x0200, 0x1000, 0x7d00, 0x7e00,
  0xfc00, 0xfe00, 0x0000, 0x0200, 0x0400, 0x2000, 0x7fff, 0x7fff,
  0xf800, 0xfc00, 0x0000, 0x0400, 0x0800, 0x4000, 0x7fff, 0x7fff,
  0xf000, 0xf800, 0x0000, 0x0800, 0x1000, 0x7fff, 0x7fff, 0x7fff,
  0xe000, 0xf000, 0x0000, 0x1000, 0x2000, 0x7fff, 0x7fff, 0x7fff,
  0xc000, 0xe000, 0x0000, 0x2000, 0x4000, 0x7fff, 0x7fff, 0x7fff,
  0x8000, 0xc000, 0x0000, 0x4000, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x8000, 0x8000, 0x0000, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0xffff, 0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f,
  0xfffe, 0x0000, 0x0002, 0x0004, 0x0020, 0x00fa, 0x00fc, 0x00fe,
  0xfffc, 0x0000, 0x0004, 0x0008, 0x0040, 0x01f4, 0x01f8, 0x01fc,
  0xfff8, 0x0000, 0x0008, 0x0010, 0x0080, 0x03e8, 0x03f0, 0x03f8,
  0xfff0, 0x0000, 0x0010, 0x0020, 0x0100, 0x07d0, 0x07e0, 0x07f0,
  0xffe0, 0x0000, 0x0020, 0x0040, 0x0200, 0x0fa0, 0x0fc0, 0x0fe0,
  0xffc0, 0x0000, 0x0040, 0x0080, 0x0400, 0x1f40, 0x1f80, 0x1fc0,
  0xff80, 0x0000, 0x0080, 0x0100, 0x0800, 0x3e80, 0x3f00, 0x3f80,
  0xff00, 0x0000, 0x0100, 0x0200, 0x1000, 0x7d00, 0x7e00, 0x7f00,
  0xfe00, 0x0000, 0x0200, 0x0400, 0x2000, 0x7fff, 0x7fff, 0x7fff,
  0xfc00, 0x0000, 0x0400, 0x0800, 0x4000, 0x7fff, 0x7fff, 0x7fff,
  0xf800, 0x0000, 0x0800, 0x1000, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0xf000, 0x0000, 0x1000, 0x2000, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0xe000, 0x0000, 0x2000, 0x4000, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0xc000, 0x0000, 0x4000, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x8000, 0x0000, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0002, 0x0004, 0x0020, 0x00fa, 0x00fc, 0x00fe, 0x6666,
  0x0000, 0x0004, 0x0008, 0x0040, 0x01f4, 0x01f8, 0x01fc, 0x7fff,
  0x0000, 0x0008, 0x0010, 0x0080, 0x03e8, 0x03f0, 0x03f8, 0x7fff,
  0x0000, 0x0010, 0x0020, 0x0100, 0x07d0, 0x07e0, 0x07f0, 0x7fff,
  0x0000, 0x0020, 0x0040, 0x0200, 0x0fa0, 0x0fc0, 0x0fe0, 0x7fff,
  0x0000, 0x0040, 0x0080, 0x0400, 0x1f40, 0x1f80, 0x1fc0, 0x7fff,
  0x0000, 0x0080, 0x0100, 0x0800, 0x3e80, 0x3f00, 0x3f80, 0x7fff,
  0x0000, 0x0100, 0x0200, 0x1000, 0x7d00, 0x7e00, 0x7f00, 0x7fff,
  0x0000, 0x0200, 0x0400, 0x2000, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x0000, 0x0400, 0x0800, 0x4000, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x0000, 0x0800, 0x1000, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x0000, 0x1000, 0x2000, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x0000, 0x2000, 0x4000, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x0000, 0x4000, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x0000, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333, 0x5555,
  0x0002, 0x0004, 0x0020, 0x00fa, 0x00fc, 0x00fe, 0x6666, 0x7fff,
  0x0004, 0x0008, 0x0040, 0x01f4, 0x01f8, 0x01fc, 0x7fff, 0x7fff,
  0x0008, 0x0010, 0x0080, 0x03e8, 0x03f0, 0x03f8, 0x7fff, 0x7fff,
  0x0010, 0x0020, 0x0100, 0x07d0, 0x07e0, 0x07f0, 0x7fff, 0x7fff,
  0x0020, 0x0040, 0x0200, 0x0fa0, 0x0fc0, 0x0fe0, 0x7fff, 0x7fff,
  0x0040, 0x0080, 0x0400, 0x1f40, 0x1f80, 0x1fc0, 0x7fff, 0x7fff,
  0x0080, 0x0100, 0x0800, 0x3e80, 0x3f00, 0x3f80, 0x7fff, 0x7fff,
  0x0100, 0x0200, 0x1000, 0x7d00, 0x7e00, 0x7f00, 0x7fff, 0x7fff,
  0x0200, 0x0400, 0x2000, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x0400, 0x0800, 0x4000, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x0800, 0x1000, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x1000, 0x2000, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x2000, 0x4000, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x4000, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333, 0x5555, 0x7ffd,
  0x0004, 0x0020, 0x00fa, 0x00fc, 0x00fe, 0x6666, 0x7fff, 0x7fff,
  0x0008, 0x0040, 0x01f4, 0x01f8, 0x01fc, 0x7fff, 0x7fff, 0x7fff,
  0x0010, 0x0080, 0x03e8, 0x03f0, 0x03f8, 0x7fff, 0x7fff, 0x7fff,
  0x0020, 0x0100, 0x07d0, 0x07e0, 0x07f0, 0x7fff, 0x7fff, 0x7fff,
  0x0040, 0x0200, 0x0fa0, 0x0fc0, 0x0fe0, 0x7fff, 0x7fff, 0x7fff,
  0x0080, 0x0400, 0x1f40, 0x1f80, 0x1fc0, 0x7fff, 0x7fff, 0x7fff,
  0x0100, 0x0800, 0x3e80, 0x3f00, 0x3f80, 0x7fff, 0x7fff, 0x7fff,
  0x0200, 0x1000, 0x7d00, 0x7e00, 0x7f00, 0x7fff, 0x7fff, 0x7fff,
  0x0400, 0x2000, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x0800, 0x4000, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x1000, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x2000, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x4000, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x0010, 0x007d, 0x007e, 0x007f, 0x3333, 0x5555, 0x7ffd, 0x7ffe,
  0x0020, 0x00fa, 0x00fc, 0x00fe, 0x6666, 0x7fff, 0x7fff, 0x7fff,
  0x0040, 0x01f4, 0x01f8, 0x01fc, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x0080, 0x03e8, 0x03f0, 0x03f8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x0100, 0x07d0, 0x07e0, 0x07f0, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x0200, 0x0fa0, 0x0fc0, 0x0fe0, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x0400, 0x1f40, 0x1f80, 0x1fc0, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x0800, 0x3e80, 0x3f00, 0x3f80, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x1000, 0x7d00, 0x7e00, 0x7f00, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x2000, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x4000, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x007d, 0x007e, 0x007f, 0x3333, 0x5555, 0x7ffd, 0x7ffe, 0x7fff,
  0x00fa, 0x00fc, 0x00fe, 0x6666, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x01f4, 0x01f8, 0x01fc, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x03e8, 0x03f0, 0x03f8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x07d0, 0x07e0, 0x07f0, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x0fa0, 0x0fc0, 0x0fe0, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x1f40, 0x1f80, 0x1fc0, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x3e80, 0x3f00, 0x3f80, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x7d00, 0x7e00, 0x7f00, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x007e, 0x007f, 0x3333, 0x5555, 0x7ffd, 0x7ffe, 0x7fff, 0x8000,
  0x00fc, 0x00fe, 0x6666, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000,
  0x01f8, 0x01fc, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000,
  0x03f0, 0x03f8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000,
  0x07e0, 0x07f0, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000,
  0x0fc0, 0x0fe0, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000,
  0x1f80, 0x1fc0, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000,
  0x3f00, 0x3f80, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000,
  0x7e00, 0x7f00, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000,
  0x007f, 0x3333, 0x5555, 0x7ffd, 0x7ffe, 0x7fff, 0x8000, 0x8001,
  0x00fe, 0x6666, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000,
  0x01fc, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000,
  0x03f8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000,
  0x07f0, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000,
  0x0fe0, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000,
  0x1fc0, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000,
  0x3f80, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000,
  0x7f00, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000,
  0x3333, 0x5555, 0x7ffd, 0x7ffe, 0x7fff, 0x8000, 0x8001, 0xaaaa,
  0x6666, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000,
  0x5555, 0x7ffd, 0x7ffe, 0x7fff, 0x8000, 0x8001, 0xaaaa, 0xcccc,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x9998,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7ffd, 0x7ffe, 0x7fff, 0x8000, 0x8001, 0xaaaa, 0xcccc, 0xff80,
  0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x9998, 0xff00,
  0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0xfe00,
  0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0xfc00,
  0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0xf800,
  0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0xf000,
  0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0xe000,
  0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0xc000,
  0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7ffe, 0x7fff, 0x8000, 0x8001, 0xaaaa, 0xcccc, 0xff80, 0xff81,
  0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x9998, 0xff00, 0xff02,
  0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0xfe00, 0xfe04,
  0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0xfc00, 0xfc08,
  0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0xf800, 0xf810,
  0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0xf000, 0xf020,
  0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0xe000, 0xe040,
  0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0xc000, 0xc080,
  0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8100,
  0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x8000, 0x8001, 0xaaaa, 0xcccc, 0xff80, 0xff81, 0xff82,
  0x7fff, 0x8000, 0x8000, 0x8000, 0x9998, 0xff00, 0xff02, 0xff04,
  0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0xfe00, 0xfe04, 0xfe08,
  0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0xfc00, 0xfc08, 0xfc10,
  0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0xf800, 0xf810, 0xf820,
  0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0xf000, 0xf020, 0xf040,
  0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0xe000, 0xe040, 0xe080,
  0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0xc000, 0xc080, 0xc100,
  0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8100, 0x8200,
  0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x8000, 0x8001, 0xaaaa, 0xcccc, 0xff80, 0xff81, 0xff82, 0xff83,
  0x8000, 0x8000, 0x8000, 0x9998, 0xff00, 0xff02, 0xff04, 0xff06,
  0x8000, 0x8000, 0x8000, 0x8000, 0xfe00, 0xfe04, 0xfe08, 0xfe0c,
  0x8000, 0x8000, 0x8000, 0x8000, 0xfc00, 0xfc08, 0xfc10, 0xfc18,
  0x8000, 0x8000, 0x8000, 0x8000, 0xf800, 0xf810, 0xf820, 0xf830,
  0x8000, 0x8000, 0x8000, 0x8000, 0xf000, 0xf020, 0xf040, 0xf060,
  0x8000, 0x8000, 0x8000, 0x8000, 0xe000, 0xe040, 0xe080, 0xe0c0,
  0x8000, 0x8000, 0x8000, 0x8000, 0xc000, 0xc080, 0xc100, 0xc180,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8100, 0x8200, 0x8300,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x8001, 0xaaaa, 0xcccc, 0xff80, 0xff81, 0xff82, 0xff83, 0xfff0,
  0x8000, 0x8000, 0x9998, 0xff00, 0xff02, 0xff04, 0xff06, 0xffe0,
  0x8000, 0x8000, 0x8000, 0xfe00, 0xfe04, 0xfe08, 0xfe0c, 0xffc0,
  0x8000, 0x8000, 0x8000, 0xfc00, 0xfc08, 0xfc10, 0xfc18, 0xff80,
  0x8000, 0x8000, 0x8000, 0xf800, 0xf810, 0xf820, 0xf830, 0xff00,
  0x8000, 0x8000, 0x8000, 0xf000, 0xf020, 0xf040, 0xf060, 0xfe00,
  0x8000, 0x8000, 0x8000, 0xe000, 0xe040, 0xe080, 0xe0c0, 0xfc00,
  0x8000, 0x8000, 0x8000, 0xc000, 0xc080, 0xc100, 0xc180, 0xf800,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8100, 0x8200, 0x8300, 0xf000,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0xe000,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0xc000,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0xaaaa, 0xcccc, 0xff80, 0xff81, 0xff82, 0xff83, 0xfff0, 0xfffd,
  0x8000, 0x9998, 0xff00, 0xff02, 0xff04, 0xff06, 0xffe0, 0xfffa,
  0x8000, 0x8000, 0xfe00, 0xfe04, 0xfe08, 0xfe0c, 0xffc0, 0xfff4,
  0x8000, 0x8000, 0xfc00, 0xfc08, 0xfc10, 0xfc18, 0xff80, 0xffe8,
  0x8000, 0x8000, 0xf800, 0xf810, 0xf820, 0xf830, 0xff00, 0xffd0,
  0x8000, 0x8000, 0xf000, 0xf020, 0xf040, 0xf060, 0xfe00, 0xffa0,
  0x8000, 0x8000, 0xe000, 0xe040, 0xe080, 0xe0c0, 0xfc00, 0xff40,
  0x8000, 0x8000, 0xc000, 0xc080, 0xc100, 0xc180, 0xf800, 0xfe80,
  0x8000, 0x8000, 0x8000, 0x8100, 0x8200, 0x8300, 0xf000, 0xfd00,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0xe000, 0xfa00,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0xc000, 0xf400,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0xe800,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0xd000,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0xa000,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0xcccc, 0xff80, 0xff81, 0xff82, 0xff83, 0xfff0, 0xfffd, 0xfffe,
  0x9998, 0xff00, 0xff02, 0xff04, 0xff06, 0xffe0, 0xfffa, 0xfffc,
  0x8000, 0xfe00, 0xfe04, 0xfe08, 0xfe0c, 0xffc0, 0xfff4, 0xfff8,
  0x8000, 0xfc00, 0xfc08, 0xfc10, 0xfc18, 0xff80, 0xffe8, 0xfff0,
  0x8000, 0xf800, 0xf810, 0xf820, 0xf830, 0xff00, 0xffd0, 0xffe0,
  0x8000, 0xf000, 0xf020, 0xf040, 0xf060, 0xfe00, 0xffa0, 0xffc0,
  0x8000, 0xe000, 0xe040, 0xe080, 0xe0c0, 0xfc00, 0xff40, 0xff80,
  0x8000, 0xc000, 0xc080, 0xc100, 0xc180, 0xf800, 0xfe80, 0xff00,
  0x8000, 0x8000, 0x8100, 0x8200, 0x8300, 0xf000, 0xfd00, 0xfe00,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0xe000, 0xfa00, 0xfc00,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0xc000, 0xf400, 0xf800,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0xe800, 0xf000,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0xd000, 0xe000,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0xa000, 0xc000,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0xff80, 0xff81, 0xff82, 0xff83, 0xfff0, 0xfffd, 0xfffe, 0xffff,
  0xff00, 0xff02, 0xff04, 0xff06, 0xffe0, 0xfffa, 0xfffc, 0xfffe,
  0xfe00, 0xfe04, 0xfe08, 0xfe0c, 0xffc0, 0xfff4, 0xfff8, 0xfffc,
  0xfc00, 0xfc08, 0xfc10, 0xfc18, 0xff80, 0xffe8, 0xfff0, 0xfff8,
  0xf800, 0xf810, 0xf820, 0xf830, 0xff00, 0xffd0, 0xffe0, 0xfff0,
  0xf000, 0xf020, 0xf040, 0xf060, 0xfe00, 0xffa0, 0xffc0, 0xffe0,
  0xe000, 0xe040, 0xe080, 0xe0c0, 0xfc00, 0xff40, 0xff80, 0xffc0,
  0xc000, 0xc080, 0xc100, 0xc180, 0xf800, 0xfe80, 0xff00, 0xff80,
  0x8000, 0x8100, 0x8200, 0x8300, 0xf000, 0xfd00, 0xfe00, 0xff00,
  0x8000, 0x8000, 0x8000, 0x8000, 0xe000, 0xfa00, 0xfc00, 0xfe00,
  0x8000, 0x8000, 0x8000, 0x8000, 0xc000, 0xf400, 0xf800, 0xfc00,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0xe800, 0xf000, 0xf800,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0xd000, 0xe000, 0xf000,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0xa000, 0xc000, 0xe000,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0xc000,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
};
const unsigned kExpectedCount_NEON_sqshl_8H_2OPIMM = 384;

#endif  // VIXL_SIM_SQSHL_8H_2OPIMM_TRACE_AARCH64_H_
