use strict;
use Test::More tests => 2;
use File::Basename 'dirname';
use Spreadsheet::ReadSXC;
use XML::Parser;
use Data::Dumper;

my $d = dirname($0);

my $workbook_ref = Spreadsheet::ReadSXC::read_sxc("$d/StockChart.ods");

my $expected = {
    Sheet1 => [
                         [
                           undef,
                           'Fun Microsystems (FUNW)',
                           undef,
                           undef,
                           undef,
                           'FUNW',
                           undef
                         ],
                         [
                           undef,
                           undef,
                           undef,
                           undef,
                           undef,
                           undef,
                           undef
                         ],
                         [
                           undef,
                           'Date',
                           'Volume',
                           'Open',
                           'Low',
                           'High',
                           'Close'
                         ],
                         [
                           undef,
                           'Apr 7, 00',
                           '15,000,000',
                           '$88.75',
                           '$88.88',
                           '$94.50',
                           '$92.69'
                         ],
                         [
                           undef,
                           'Apr 8, 00',
                           '14,652,562',
                           '$92.69',
                           '$87.00',
                           '$95.50',
                           '$93.69'
                         ],
                         [
                           undef,
                           'Apr 9, 00',
                           '15,070,589',
                           '$93.69',
                           '$91.00',
                           '$96.50',
                           '$92.00'
                         ],
                         [
                           undef,
                           'Apr 10, 00',
                           '15,207,571',
                           '$92.00',
                           '$90.00',
                           '$97.50',
                           '$93.00'
                         ],
                         [
                           undef,
                           'Apr 11, 00',
                           '14,869,716',
                           '$93.00',
                           '$90.00',
                           '$98.50',
                           '$93.60'
                         ],
                         [
                           undef,
                           'Apr 12, 00',
                           '15,225,943',
                           '$93.60',
                           '$87.00',
                           '$99.50',
                           '$93.80'
                         ],
                         [
                           undef,
                           'Apr 13, 00',
                           '15,243,446',
                           '$93.80',
                           '$88.00',
                           '$100.50',
                           '$94.00'
                         ],
                         [
                           undef,
                           'Apr 14, 00',
                           '14,889,873',
                           '$94.00',
                           '$89.00',
                           '$101.50',
                           '$93.00'
                         ],
                         [
                           undef,
                           'Apr 15, 00',
                           '14,781,243',
                           '$93.00',
                           '$90.00',
                           '$100.00',
                           '$92.00'
                         ],
                         [
                           undef,
                           'Apr 16, 00',
                           '15,132,068',
                           '$92.00',
                           '$88.00',
                           '$96.00',
                           '$92.00'
                         ],
                         [
                           undef,
                           'Apr 17, 00',
                           '15,253,822',
                           '$92.00',
                           '$89.00',
                           '$95.00',
                           '$93.00'
                         ],
                         [
                           undef,
                           'Apr 18, 00',
                           '14,919,019',
                           '$93.00',
                           '$93.00',
                           '$97.00',
                           '$95.00'
                         ],
                         [
                           undef,
                           'Apr 19, 00',
                           '14,972,533',
                           '$95.00',
                           '$84.00',
                           '$95.00',
                           '$91.00'
                         ],
                         [
                           undef,
                           'Apr 20, 00',
                           '14,642,786',
                           '$91.00',
                           '$87.00',
                           '$100.00',
                           '$97.00'
                         ],
                         [
                           undef,
                           'Apr 21, 00',
                           '14,804,376',
                           '$97.00',
                           '$91.00',
                           '$98.00',
                           '$96.00'
                         ],
                         [
                           undef,
                           'Apr 22, 00',
                           '14,907,452',
                           '$96.00',
                           '$92.00',
                           '$102.00',
                           '$95.00'
                         ],
                         [
                           undef,
                           'Apr 23, 00',
                           '15,319,376',
                           '$95.00',
                           '$91.00',
                           '$96.00',
                           '$93.00'
                         ],
                         [
                           undef,
                           'Apr 24, 00',
                           '15,066,118',
                           '$93.00',
                           '$94.00',
                           '$99.00',
                           '$98.00'
                         ]
    ],
    Sheet2 => [],
    Sheet3 => [],
};

is_deeply $workbook_ref, $expected, "StockChart.ods gets parsed identically"
    or diag Dumper $workbook_ref;

$workbook_ref = Spreadsheet::ReadSXC::read_sxc("$d/StockChart.ods", {    StandardCurrency    => 1,
    StandardDate        => 1,
    StandardTime        => 1,
});

$expected = {
           'Sheet1' => [
                         [
                           undef,
                           'Fun Microsystems (FUNW)',
                           undef,
                           undef,
                           undef,
                           'FUNW',
                           undef
                         ],
                         [
                           undef,
                           undef,
                           undef,
                           undef,
                           undef,
                           undef,
                           undef
                         ],
                         [
                           undef,
                           'Date',
                           'Volume',
                           'Open',
                           'Low',
                           'High',
                           'Close'
                         ],
                         [
                           undef,
                           '2000-04-07',
                           '15000000',
                           '88.75',
                           '88.875',
                           '94.5',
                           '92.6875'
                         ],
                         [
                           undef,
                           '2000-04-08',
                           '14652562',
                           '92.6875',
                           '87',
                           '95.5',
                           '93.6875'
                         ],
                         [
                           undef,
                           '2000-04-09',
                           '15070589',
                           '93.6875',
                           '91',
                           '96.5',
                           '92'
                         ],
                         [
                           undef,
                           '2000-04-10',
                           '15207571',
                           '92',
                           '90',
                           '97.5',
                           '93'
                         ],
                         [
                           undef,
                           '2000-04-11',
                           '14869716',
                           '93',
                           '90',
                           '98.5',
                           '93.6'
                         ],
                         [
                           undef,
                           '2000-04-12',
                           '15225943',
                           '93.6',
                           '87',
                           '99.5',
                           '93.8'
                         ],
                         [
                           undef,
                           '2000-04-13',
                           '15243446',
                           '93.8',
                           '88',
                           '100.5',
                           '94'
                         ],
                         [
                           undef,
                           '2000-04-14',
                           '14889873',
                           '94',
                           '89',
                           '101.5',
                           '93'
                         ],
                         [
                           undef,
                           '2000-04-15',
                           '14781243',
                           '93',
                           '90',
                           '100',
                           '92'
                         ],
                         [
                           undef,
                           '2000-04-16',
                           '15132068',
                           '92',
                           '88',
                           '96',
                           '92'
                         ],
                         [
                           undef,
                           '2000-04-17',
                           '15253822',
                           '92',
                           '89',
                           '95',
                           '93'
                         ],
                         [
                           undef,
                           '2000-04-18',
                           '14919019',
                           '93',
                           '93',
                           '97',
                           '95'
                         ],
                         [
                           undef,
                           '2000-04-19',
                           '14972533',
                           '95',
                           '84',
                           '95',
                           '91'
                         ],
                         [
                           undef,
                           '2000-04-20',
                           '14642786',
                           '91',
                           '87',
                           '100',
                           '97'
                         ],
                         [
                           undef,
                           '2000-04-21',
                           '14804376',
                           '97',
                           '91',
                           '98',
                           '96'
                         ],
                         [
                           undef,
                           '2000-04-22',
                           '14907452',
                           '96',
                           '92',
                           '102',
                           '95'
                         ],
                         [
                           undef,
                           '2000-04-23',
                           '15319376',
                           '95',
                           '91',
                           '96',
                           '93'
                         ],
                         [
                           undef,
                           '2000-04-24',
                           '15066118',
                           '93',
                           '94',
                           '99',
                           '98'
                         ]
                       ],
    Sheet2 => [],
    Sheet3 => [],
};

is_deeply $workbook_ref, $expected, "StockChart.ods gets parsed identically with standardized values"
    or diag Dumper $workbook_ref;

