package com.representqueens.spark.util;

/*
 * 
 * Copyright 2006 Larry Ogrodnek
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
 
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

import com.representqueens.util.ColorUtils;
import com.representqueens.util.StringUtils;

/**
 * 
 * @author Larry Ogrodnek <larry@cheesesteak.net>
 * @version $Revision: 1.1 $ $Date: 2006-11-20 02:58:38 $
 */
public final class StringConversion
{
  private StringConversion() { }

  public static final Number[] getData(final String s)
  {
    final String[] data = s.split(",");

    final List<Float> out = new ArrayList<Float>(data.length);

    for (final String d : data)
    {
      out.add(Float.parseFloat(d));
    }

    return out.toArray(new Number[out.size()]);
  }


  public static final Color convertColor(final String s,
                                         final Color defValue)
  {
    Color color = null;

    if (!StringUtils.isEmpty(s))
    {
      color = ColorUtils.parseColor(s);
    }

    return (color == null ? defValue : color);
  }


  public static final int convertInt(final String s,
                                             final int defValue)
  {
    if (! StringUtils.isEmpty(s))
    {
      try
      {
        return Integer.parseInt(s);
      }
      catch (final NumberFormatException nfe)
      {
        // fall through, return default
      }
    }

    return defValue;
  }
}
