#
# @file    TestSBMLNamespaces.py
# @brief   SBMLNamespaces unit tests
#
# @author  Akiya Jouraku (Python conversion)
# @author  Sarah Keating 
# 
# ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
#
# DO NOT EDIT THIS FILE.
#
# This file was generated automatically by converting the file located at
# src/sbml/test/TestSBMLNamespaces.cpp
# using the conversion program dev/utilities/translateTests/translateTests.pl.
# Any changes made here will be lost the next time the file is regenerated.
#
# -----------------------------------------------------------------------------
# This file is part of libSBML.  Please visit http://sbml.org for more
# information about SBML, and the latest version of libSBML.
#
# Copyright 2005-2010 California Institute of Technology.
# Copyright 2002-2005 California Institute of Technology and
#                     Japan Science and Technology Corporation.
# 
# This library is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation.  A copy of the license agreement is provided
# in the file named "LICENSE.txt" included with this software distribution
# and also available online as http://sbml.org/software/libsbml/license.html
# -----------------------------------------------------------------------------

import sys
import unittest
import libsbml


class TestSBMLNamespaces(unittest.TestCase):


  def test_SBMLNamespaces_L1V1(self):
    sbml = libsbml.SBMLNamespaces(1,1)
    self.assertTrue( sbml.getLevel() == 1 )
    self.assertTrue( sbml.getVersion() == 1 )
    ns = sbml.getNamespaces()
    self.assertTrue( ns.getLength() == 1 )
    self.assertTrue( ns.getURI(0) ==  "http://www.sbml.org/sbml/level1" )
    self.assertTrue( ns.getPrefix(0) ==  "" )
    sbml = None
    pass  

  def test_SBMLNamespaces_L1V2(self):
    sbml = libsbml.SBMLNamespaces(1,2)
    self.assertTrue( sbml.getLevel() == 1 )
    self.assertTrue( sbml.getVersion() == 2 )
    ns = sbml.getNamespaces()
    self.assertTrue( ns.getLength() == 1 )
    self.assertTrue( ns.getURI(0) ==  "http://www.sbml.org/sbml/level1" )
    self.assertTrue( ns.getPrefix(0) ==  "" )
    sbml = None
    pass  

  def test_SBMLNamespaces_L2V1(self):
    sbml = libsbml.SBMLNamespaces(2,1)
    self.assertTrue( sbml.getLevel() == 2 )
    self.assertTrue( sbml.getVersion() == 1 )
    ns = sbml.getNamespaces()
    self.assertTrue( ns.getLength() == 1 )
    self.assertTrue( ns.getURI(0) ==  "http://www.sbml.org/sbml/level2" )
    self.assertTrue( ns.getPrefix(0) ==  "" )
    sbml = None
    pass  

  def test_SBMLNamespaces_L2V2(self):
    sbml = libsbml.SBMLNamespaces(2,2)
    self.assertTrue( sbml.getLevel() == 2 )
    self.assertTrue( sbml.getVersion() == 2 )
    ns = sbml.getNamespaces()
    self.assertTrue( ns.getLength() == 1 )
    self.assertTrue( ns.getURI(0) ==  "http://www.sbml.org/sbml/level2/version2" )
    self.assertTrue( ns.getPrefix(0) ==  "" )
    sbml = None
    pass  

  def test_SBMLNamespaces_L2V3(self):
    sbml = libsbml.SBMLNamespaces(2,3)
    self.assertTrue( sbml.getLevel() == 2 )
    self.assertTrue( sbml.getVersion() == 3 )
    ns = sbml.getNamespaces()
    self.assertTrue( ns.getLength() == 1 )
    self.assertTrue( ns.getURI(0) ==  "http://www.sbml.org/sbml/level2/version3" )
    self.assertTrue( ns.getPrefix(0) ==  "" )
    sbml = None
    pass  

  def test_SBMLNamespaces_L2V4(self):
    sbml = libsbml.SBMLNamespaces(2,4)
    self.assertTrue( sbml.getLevel() == 2 )
    self.assertTrue( sbml.getVersion() == 4 )
    ns = sbml.getNamespaces()
    self.assertTrue( ns.getLength() == 1 )
    self.assertTrue( ns.getURI(0) ==  "http://www.sbml.org/sbml/level2/version4" )
    self.assertTrue( ns.getPrefix(0) ==  "" )
    sbml = None
    pass  

  def test_SBMLNamespaces_L3V1(self):
    sbml = libsbml.SBMLNamespaces(3,1)
    self.assertTrue( sbml.getLevel() == 3 )
    self.assertTrue( sbml.getVersion() == 1 )
    ns = sbml.getNamespaces()
    self.assertTrue( ns.getLength() == 1 )
    self.assertTrue( ns.getURI(0) ==  "http://www.sbml.org/sbml/level3/version1/core" )
    self.assertTrue( ns.getPrefix(0) ==  "" )
    sbml = None
    pass  

  def test_SBMLNamespaces_add_and_remove_namespaces(self):
    sbmlns = libsbml.SBMLNamespaces( 3,1 )
    self.assertTrue( sbmlns.getLevel() == 3 )
    self.assertTrue( sbmlns.getVersion() == 1 )
    sbmlns.addNamespace("http://www.sbml.org/sbml/level3/version1/group/version1",  "group")
    sbmlns.addNamespace("http://www.sbml.org/sbml/level3/version1/layout/version1", "layout")
    sbmlns.addNamespace("http://www.sbml.org/sbml/level3/version1/render/version1", "render")
    sbmlns.addNamespace("http://www.sbml.org/sbml/level3/version1/multi/version1",  "multi")
    ns = sbmlns.getNamespaces()
    self.assertTrue( ns.getLength() == 5 )
    self.assertTrue( ns.getURI(0) ==  "http://www.sbml.org/sbml/level3/version1/core" )
    self.assertTrue( ns.getPrefix(0) ==  "" )
    self.assertTrue( ns.getURI(1) ==  "http://www.sbml.org/sbml/level3/version1/group/version1" )
    self.assertTrue( ns.getPrefix(1) ==  "group" )
    self.assertTrue( ns.getURI(2) ==  "http://www.sbml.org/sbml/level3/version1/layout/version1" )
    self.assertTrue( ns.getPrefix(2) ==  "layout" )
    self.assertTrue( ns.getURI(3) ==  "http://www.sbml.org/sbml/level3/version1/render/version1" )
    self.assertTrue( ns.getPrefix(3) ==  "render" )
    self.assertTrue( ns.getURI(4) ==  "http://www.sbml.org/sbml/level3/version1/multi/version1" )
    self.assertTrue( ns.getPrefix(4) ==  "multi" )
    sbmlns.removeNamespace("http://www.sbml.org/sbml/level3/version1/layout/version1")
    sbmlns.removeNamespace("http://www.sbml.org/sbml/level3/version1/group/version1")
    sbmlns.removeNamespace("http://www.sbml.org/sbml/level3/version1/render/version1")
    sbmlns.removeNamespace("http://www.sbml.org/sbml/level3/version1/multi/version1")
    pass  

  def test_SBMLNamespaces_getURI(self):
    self.assertTrue( libsbml.SBMLNamespaces.getSBMLNamespaceURI(1,1) ==                              "http://www.sbml.org/sbml/level1" )
    self.assertTrue( libsbml.SBMLNamespaces.getSBMLNamespaceURI(1,2) ==                              "http://www.sbml.org/sbml/level1" )
    self.assertTrue( libsbml.SBMLNamespaces.getSBMLNamespaceURI(2,1) ==                              "http://www.sbml.org/sbml/level2" )
    self.assertTrue( libsbml.SBMLNamespaces.getSBMLNamespaceURI(2,2) ==                              "http://www.sbml.org/sbml/level2/version2" )
    self.assertTrue( libsbml.SBMLNamespaces.getSBMLNamespaceURI(2,3) ==                              "http://www.sbml.org/sbml/level2/version3" )
    self.assertTrue( libsbml.SBMLNamespaces.getSBMLNamespaceURI(2,4) ==                              "http://www.sbml.org/sbml/level2/version4" )
    self.assertTrue( libsbml.SBMLNamespaces.getSBMLNamespaceURI(3,1) ==                              "http://www.sbml.org/sbml/level3/version1/core" )
    pass  

def suite():
  suite = unittest.TestSuite()
  suite.addTest(unittest.TestLoader.loadTestsFromTestCase(TestSBMLNamespaces))

  return suite

if __name__ == "__main__":
  if unittest.TextTestRunner(verbosity=1).run(suite()).wasSuccessful() :
    sys.exit(0)
  else:
    sys.exit(1)
