/* Generated by re2c */
// re2c $INPUT -o $OUTPUT -f --loop-switch -i
#include <assert.h>
#include <stdio.h>
#include <string.h>

#define DEBUG    1
#define LOG(...) if (DEBUG) fprintf(stderr, __VA_ARGS__);
#define BUFSIZE  10

typedef struct {
    FILE *file;
    char buf[BUFSIZE + 1], *lim, *cur, *mar, *tok;
    unsigned yyaccept;
    int state;
} Input;

static void init(Input *in, FILE *f)
{
    in->file = f;
    in->cur = in->mar = in->tok = in->lim = in->buf + BUFSIZE;
    in->lim[0] = 0; // append sentinel symbol
    in->yyaccept = 0;
    in->state = -1;
}

typedef enum {END, READY, WAITING, BAD_PACKET, BIG_PACKET} Status;

static Status fill(Input *in)
{
    const size_t shift = in->tok - in->buf;
    const size_t free = BUFSIZE - (in->lim - in->tok);

    if (free < 1) return BIG_PACKET;

    memmove(in->buf, in->tok, BUFSIZE - shift);
    in->lim -= shift;
    in->cur -= shift;
    in->mar -= shift;
    in->tok -= shift;

    const size_t read = fread(in->lim, 1, free, in->file);
    in->lim += read;
    in->lim[0] = 0; // append sentinel symbol

    return READY;
}

static Status lex(Input *in, unsigned int *recv)
{
    char yych;
loop:
    
{
	int yystate = in->state;
	for (;;) {
		switch (yystate) {
			case -1:
			case 0:
				yych = *in->cur;
				switch (yych) {
					case 'a':
					case 'b':
					case 'c':
					case 'd':
					case 'e':
					case 'f':
					case 'g':
					case 'h':
					case 'i':
					case 'j':
					case 'k':
					case 'l':
					case 'm':
					case 'n':
					case 'o':
					case 'p':
					case 'q':
					case 'r':
					case 's':
					case 't':
					case 'u':
					case 'v':
					case 'w':
					case 'x':
					case 'y':
					case 'z':
						++in->cur;
						yystate = 3;
						continue;
					default:
						if (in->lim <= in->cur) {
							in->state = 8;
							return WAITING;
						}
						++in->cur;
						yystate = 1;
						continue;
				}
			case 1:
				yystate = 2;
				continue;
			case 2:
				in->state = -1;
				{ return BAD_PACKET; }
			case 3:
				in->mar = in->cur;
				yych = *in->cur;
				switch (yych) {
					case ';':
						++in->cur;
						yystate = 4;
						continue;
					case 'a':
					case 'b':
					case 'c':
					case 'd':
					case 'e':
					case 'f':
					case 'g':
					case 'h':
					case 'i':
					case 'j':
					case 'k':
					case 'l':
					case 'm':
					case 'n':
					case 'o':
					case 'p':
					case 'q':
					case 'r':
					case 's':
					case 't':
					case 'u':
					case 'v':
					case 'w':
					case 'x':
					case 'y':
					case 'z':
						++in->cur;
						yystate = 5;
						continue;
					default:
						if (in->lim <= in->cur) {
							in->state = 9;
							return WAITING;
						}
						yystate = 2;
						continue;
				}
			case 4:
				in->state = -1;
				{ *recv = *recv + 1; in->tok = in->cur; goto loop; }
			case 5:
				yych = *in->cur;
				switch (yych) {
					case ';':
						++in->cur;
						yystate = 4;
						continue;
					case 'a':
					case 'b':
					case 'c':
					case 'd':
					case 'e':
					case 'f':
					case 'g':
					case 'h':
					case 'i':
					case 'j':
					case 'k':
					case 'l':
					case 'm':
					case 'n':
					case 'o':
					case 'p':
					case 'q':
					case 'r':
					case 's':
					case 't':
					case 'u':
					case 'v':
					case 'w':
					case 'x':
					case 'y':
					case 'z':
						++in->cur;
						yystate = 5;
						continue;
					default:
						if (in->lim <= in->cur) {
							in->state = 10;
							return WAITING;
						}
						yystate = 6;
						continue;
				}
			case 6:
				in->cur = in->mar;
				yystate = 2;
				continue;
			case 7:
				in->state = -1;
				{ return END; }
			case 8:
				if (in->lim <= in->cur) {
					yystate = 7;
					continue;
				}
				yystate = 0;
				continue;
			case 9:
				if (in->lim <= in->cur) {
					yystate = 2;
					continue;
				}
				yystate = 3;
				continue;
			case 10:
				if (in->lim <= in->cur) {
					yystate = 6;
					continue;
				}
				yystate = 5;
				continue;
		}
	}
}

}

void test(const char **packets, Status status)
{
    const char *fname = "pipe";
    FILE *fw = fopen(fname, "w");
    FILE *fr = fopen(fname, "r");
    setvbuf(fw, NULL, _IONBF, 0);
    setvbuf(fr, NULL, _IONBF, 0);

    Input in;
    init(&in, fr);
    Status st;
    unsigned int send = 0, recv = 0;

    for (;;) {
        st = lex(&in, &recv);
        if (st == END) {
            LOG("done: got %u packets\n", recv);
            break;
        } else if (st == WAITING) {
            LOG("waiting...\n");
            if (*packets) {
                LOG("sent packet %u\n", send);
                fprintf(fw, "%s", *packets++);
                ++send;
            }
            st = fill(&in);
            LOG("queue: '%s'\n", in.buf);
            if (st == BIG_PACKET) {
                LOG("error: packet too big\n");
                break;
            }
            assert(st == READY);
        } else {
            assert(st == BAD_PACKET);
            LOG("error: ill-formed packet\n");
            break;
        }
    }

    LOG("\n");
    assert(st == status);
    if (st == END) assert(recv == send);

    fclose(fw);
    fclose(fr);
    remove(fname);
}

int main()
{
    const char *packets1[] = {0};
    const char *packets2[] = {"zero;", "one;", "two;", "three;", "four;", 0};
    const char *packets3[] = {"zer0;", 0};
    const char *packets4[] = {"goooooooooogle;", 0};

    test(packets1, END);
    test(packets2, END);
    test(packets3, BAD_PACKET);
    test(packets4, BIG_PACKET);

    return 0;
}
