// re2js $INPUT -o $OUTPUT

const assert = require('assert')

function parse(yyinput) {
    let yycursor = 0

    // Final tag variables available in semantic action.
    /*!svars:re2c format = "let @@\n"; */
    /*!mvars:re2c format = "let @@\n"; */

    // Intermediate tag variables used by the lexer (must be autogenerated).
    /*!stags:re2c format = "let @@\n"; */
    /*!mtags:re2c format = "let @@ = []\n"; */

    /*!re2c
        re2c:YYMTAGP = "@@.push(yycursor)";
        re2c:YYMTAGN = ""; // do nothing
        re2c:yyfill:enable = 0;
        re2c:tags = 1;

        num = [0-9]+;

        @t1 num @t2 ("." #t3 num #t4)* [\x00] {
            let vers = [Number(yyinput.substring(t1, t2))]
            for (let i = 0; i < t3.length; ++i) {
                vers.push(Number(yyinput.substring(t3[i], t4[i])))
            }
            return vers
        }
        * { return null }
    */
}

assert.deepEqual(parse("1\0"), [1])
assert.deepEqual(parse("1.2.3.4.5.6.7\0"), [1, 2, 3, 4, 5, 6, 7])
assert.deepEqual(parse("1.2.\0"), null)
