--
-- PGP compression support
--

select pgp_sym_decrypt(dearmor('
-----BEGIN PGP MESSAGE-----

ww0ECQMCsci6AdHnELlh0kQB4jFcVwHMJg0Bulop7m3Mi36s15TAhBo0AnzIrRFrdLVCkKohsS6+
DMcmR53SXfLoDJOv/M8uKj3QSq7oWNIp95pxfA==
=tbSn
-----END PGP MESSAGE-----
'), 'key', 'expect-compress-algo=1');

select pgp_sym_decrypt(
	pgp_sym_encrypt('Secret message', 'key', 'compress-algo=0'),
	'key', 'expect-compress-algo=0');

select pgp_sym_decrypt(
	pgp_sym_encrypt('Secret message', 'key', 'compress-algo=1'),
	'key', 'expect-compress-algo=1');

select pgp_sym_decrypt(
	pgp_sym_encrypt('Secret message', 'key', 'compress-algo=2'),
	'key', 'expect-compress-algo=2');

-- level=0 should turn compression off
select pgp_sym_decrypt(
	pgp_sym_encrypt('Secret message', 'key',
			'compress-algo=2, compress-level=0'),
	'key', 'expect-compress-algo=0');

-- check corner case involving an input string of 16kB, as per bug #16476.
SELECT setseed(0);
WITH random_string AS
(
  -- This generates a random string of 16366 bytes.  This is chosen
  -- as random so that it does not get compressed, and the decompression
  -- would work on a string with the same length as the origin, making the
  -- test behavior more predictable.  lpad() ensures that the generated
  -- hexadecimal value is completed by extra zero characters if random()
  -- has generated a value strictly lower than 16.
  SELECT string_agg(decode(lpad(to_hex((random()*256)::int), 2, '0'), 'hex'), '') as bytes
    FROM generate_series(0, 16365)
)
SELECT bytes =
    pgp_sym_decrypt_bytea(
      pgp_sym_encrypt_bytea(bytes, 'key',
                            'compress-algo=1,compress-level=1'),
                            'key', 'expect-compress-algo=1')
    AS is_same
  FROM random_string;
